//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.4

Rectangle {
    id : key

    property color normalColor    : "#EEE"
    property color highlightColor : "#7AC1DF"

    property bool  pressed : false

    readonly property bool highlight :
        triggerTimer.running ||
        (mouseArea.pressed && mouseArea.containsMouse) ||
        key.pressed

    signal clicked()

    width  : 60
    height : 60
    color  : {
        if (!enabled)
            return "#AAA";

        return highlight ? highlightColor : normalColor;
    }

    Behavior on color {
        ColorAnimation { duration : 70 }
    }

    Timer {
        id : triggerTimer

        interval    : 100
        repeat      : false
        onTriggered : key.clicked();
    }

    MouseArea {
        id : mouseArea

        anchors.fill : parent
        onReleased   : {
            if (mouseArea.containsMouse) {
                triggerTimer.start();
            }
        }
    }
}

